<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/OEMIS.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v5_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v5_0/Trader.xsd" xmlns:oemis="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/OEMIS.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v5_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v5_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="UTF-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:value-of select="name()"/> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_oemis" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_oemis"> <xsl:for-each select=" ns1:Header |  ns4:* | oemis:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:apply-templates mode="KwotaPodatku" select="."/> <!-- SZABLON DOT. WYROBOW --> <xsl:apply-templates mode="Wyroby" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <xsl:apply-templates mode="Adnotacje" select="."/> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <xsl:choose> <xsl:when test="string-length(@identifier)='10'"> <b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> składającego</b> <sup>1)</sup> </xsl:when> <xsl:otherwise> <b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL <sup>(niepotrzebne skreślić)</sup> składającego<sup>1)</sup> </b> </xsl:otherwise> </xsl:choose> </span> </td> <td align="center" colspan="2" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>2. Numer zgłoszenia celnego<sup>2)</sup> </b> <br/> <span class="cz16"> <b> <xsl:value-of select="//@nrSAD"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" height="45" valign="top"> <b>3. Numer dokumentu</b> <br/> <span class="cz16"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" height="45" valign="top"> <b>4. Status</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | oemis:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">OEMIS</span> </td> </tr> <tr> <!--<td height="61" width="154"/> --> <td> <div align="left"> <span class="nag1">INFORMACJA W SPRAWIE OPŁATY EMISYJNEJ</span> <br/> <span class="nag1">za </span> </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | oemis:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>5. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>6. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <br/> <div align="center" class="cz18"/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | oemis:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 321h ust. 1 ustawy z dnia 27 kwietnia 2001 r. – Prawo ochrony środowiska (Dz. U. z 2021 r. poz. 1973, z późn. zm.). </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top"> a)	do 25. dnia miesiąca następującego po miesiącu, w którym powstał obowiązek zapłaty – w przypadku producenta paliw silnikowych, podmiotu dokonującego nabycia wewnątrzwspólnotowego w rozumieniu przepisów o podatku akcyzowym paliw silnikowych oraz innego podmiotu podlegającego na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych – jeżeli podlega on na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych z innego tytułu niż import,<br/> b)	określony dla należności celnych – w przypadku importera paliw silnikowych oraz innego podmiotu podlegającego na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych – jeżeli podlega on na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych z tytułu importu.</td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top"> a)	urząd skarbowy, przy pomocy którego swoje zadania wykonuje naczelnik urzędu skarbowego właściwy miejscowo w sprawach podatku akcyzowego – w przypadku producenta paliw silnikowych, podmiotu dokonującego nabycia wewnątrzwspólnotowego w rozumieniu przepisów o podatku akcyzowym paliw silnikowych oraz innego podmiotu podlegającego na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych – jeżeli podlega on na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych z innego tytułu niż import,<br/> b)	urząd celno-skarbowy, przy pomocy którego swoje zadania wykonuje naczelnik urzędu celno-skarbowego właściwy ze względu na miejsce powstania długu celnego – w przypadku importera paliw silnikowych oraz innego podmiotu podlegającego na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych – jeżeli podlega on na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych z tytułu importu.</td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | oemis:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA INFORMACJI</span> </td> </tr> <tr align="left"> <td bgcolor="#CCCCCC" rowspan="2" width="40"/> <td align="left" rowspan="2" valign="top" width="425"> <b>7. Naczelnik urzędu skarbowego lub naczelnik urzędu celno–skarbowego</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="@taxOffice"/> </span> </td> <td align="left" colspan="2" valign="top"> <b>8. Cel złożenia formularza </b> <sup>(zaznaczyć właściwy kwadrat)</sup> </td> </tr> <tr> <td align="left" valign="top">1. złożenie informacji<br/> <span class="cz18"> <xsl:choose> <xsl:when test="//@submissionAim='Deklaracja'"> <b>☑</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> <td align="left" valign="top">2. korekta informacji <br/> <span class="cz18"> <xsl:choose> <xsl:when test="//@submissionAim='Korekta'"> <b>☑</b> <!--	<span class="cz10"> <xsl:value-of select="@justification"/> </span> --> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | oemis:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE SKŁADAJĄCEGO INFORMACJĘ</span> <br/> * Dotyczy podmiotów niebędących osobami fizycznymi. ** Dotyczy podmiotów będących osobami fizycznymi.</td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE </span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>9. Rodzaj składającego</b> <sup>(zaznaczyć właściwy kwadrat)</sup> </td> </tr> <tr> <td align="left" valign="top">1. składający niebędący osobą fizyczną <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='N'"> <b>☑</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <span class="cz18"> <xsl:choose> <xsl:when test=".//ns1:Trader/@typeOfTaxpayer='F'"> <b>☑</b> </xsl:when> <xsl:otherwise> <b/> </xsl:otherwise> </xsl:choose> </span> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>10. Nazwa pełna* / nazwisko, pierwsze imię** </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> <span class="cz18"> <xsl:value-of select="//@firstName"/> </span> <span class="cz18"> <xsl:value-of select="//@surname"/> </span> <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | oemis:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA** </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>11. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>12. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>13. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>14. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>15. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>16. Numer domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>17. Numer lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="4"> <b>18. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td> <b>19. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:template match="ns1:Header | oemis:*" mode="KwotaPodatku"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="4"> <b>C. WYSOKOŚĆ OPŁATY EMISYJNEJ </b> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="4" width="40"> <p/> <p/> <p/> <p/> </td> <td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"> <b>Opłata emisyjna do zapłaty </b> <p/> Kwota z poz. 116</td> <td align="left" colspan="2" valign="top" width="283"> <b>20.</b> <br/> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(//@sum),'# ##0')"/> </div> <br/> <div align="right" class="cz19" valign="top">zł</div> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">OEMIS</span> 1/<sub style="cz9"/>(2) </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | oemis:*" mode="Wyroby"> <!-- TABELKA DLA I --> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"/> <table border="1" width="955"> <!-- NAGLOWEK --> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="6"> <span class="nag1">D. OBLICZENIE WYSOKOŚCI OPŁATY EMISYJNEJ</span> </td> </tr> <!-- I-OPIS --> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td width="20"> <p align="center"> Lp. </p> </td> <!-- <td width="110"> Rodzaj opłaty paliwowej</td> --> <td width="260"> <p align="center">Nazwa wyrobów podlegających opłacie emisyjnej </p> </td> <td width="110"> <p align="center">Kod CN</p> </td> <td width="110"> <p align="center">Podstawa obliczenia wysokości opłaty emisyjnej <sup>3)</sup> </p> </td> <!--<td width="110"> <p align="center">Ilość wyrobów, od jakich podmioty, są zobowiązane zapłacić podatek akcyzowy</p> </td> --> <td width="107"> Stawka opłaty emisyjnej</td> <td width="133"> <p align="center">Opłata emisyjna<sup>4)</sup> </p> </td> </tr> <!-- II-WIERSZ - OZNACZENIE --> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td> <div align="center"> <b>a.</b> </div> </td> <td> <div align="center"> <b>b.</b> </div> </td> <td> <div align="center"> <b>c.</b> </div> </td> <td> <div align="center"> <b>d.</b> </div> </td> <td> <div align="center"> <b>e.</b> </div> </td> <td> <div align="center"> <b>f.</b> </div> </td> </tr> <!-- III - WARTOSCI --> <xsl:for-each select="//ns1:Item | //oemis:Item"> <tr align="left" valign="top"> <td> <div align="left" class="cz18" valign="top"> <xsl:value-of select="@id"/> </div> </td> <!-- <td> <div align="left" class="cz18" valign="top"> <xsl:value-of select="@typeOfFuelFee"/> </div> <xsl:if test="@typeOfFuelFee = '768'"> - Opłaty pobrane od producentów paliw silnikowych</xsl:if> <xsl:if test="@typeOfFuelFee = '770'"> - Opłaty pobrane od podmiotu dokonującego sprzedaży detalicznej gazu</xsl:if> <xsl:if test="@typeOfFuelFee = '770a'"> - Opłaty pobrane od producenta gazu</xsl:if> <xsl:if test="@typeOfFuelFee = '788'"> - Opłaty pobierane od podmiotów dokonujących nabycia wewnatrzwspolnotowego paliw</xsl:if> <xsl:if test="@typeOfFuelFee = '789'"> - Opłaty pobierane od podmiotów dokonujących nabycia wewnątrzwspólnotowego gazu</xsl:if> </td> --> <td> <div align="left" class="cz14" valign="top"> <xsl:value-of select="@groupOfGoodsName"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@codeCN"/> </div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@numberOfGoods"/> </div> </td> <!-- <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@numberOfGoods"/> </div> </td> --> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@taxRate"/> </div> <div align="right" class="cz19" valign="top">zł</div> </td> <td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(@amountOfFee),'# ##0')"/> </div> <div align="right" class="cz19" valign="top">zł</div> </td> </tr> </xsl:for-each> <!-- PODSUMOWANIE TABELKI --> <xsl:for-each select="."> <!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> --> <tr> <!--<td>-</td> --> <td bgcolor="#CCCCCC" colspan="5"> <b>Razem </b> </td> <td> <b>116.</b> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(.//@sum),'# ##0')"/>  </div> <div align="right" class="cz19" valign="top">zł</div> </td> </tr> </xsl:for-each> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | oemis:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">E. PODPIS SKŁADAJĄCEGO INFORMACJĘ LUB OSOBY REPREZENTUJĄCEJ SKŁADAJĄCEGO INFORMACJĘ</span> </b> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td height="37" width="402"> <b>117. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>118. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname"/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>119.Data wypełnienia informacji </b>(dzień-miesiąc-rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> <td> <b>120. Podpis składającego informację lub osoby reprezentującej składającego informację</b> </td> </tr> <tr align="left" valign="top"> <td colspan="2" height="70"> <b>121. Numer telefonu i adres e-mail składającego informację lub osoby reprezentującej składającego informację </b>(pole nieobowiązkowe) <br/> <br/> <span class="cz18"> <xsl:value-of select="ns1:Statement/ns3:representative/@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="3" height="36"> <span class="nag1">F. ADNOTACJE ORGANU</span> <br/>W przypadku informacji złożonej w wersji elektronicznej wypełnienie pól: 122, 123 i 124 jest nieobowiązkowe. </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>122. Uwagi organu<br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td height="49" width="472"> <b>123. Identyfikator przyjmującego formularz <br/> <br/> <br/> </b> <p/> </td> <td width="421"> <b>124. Podpis przyjmującego formularz </b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | oemis:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia:</b> </p> <br/> <p> <sup>1)</sup>Numer PESEL należy podać w przypadku składającego informację będącego osobą fizyczną objętą rejestrem PESEL nieprowadzącą działalności gospodarczej lub niebędącą zarejestrowanym podatnikiem podatku od towarów i usług.</p> <p> <sup>2)</sup>Numer zgłoszenia celnego należy podać w przypadku składającego informację będącego importerem paliw silnikowych oraz innym podmiotem podlegającym na podstawie przepisów o podatku akcyzowym obowiązkowi podatkowemu w zakresie podatku akcyzowego od paliw silnikowych.</p> <p> <sup>3)</sup>Podstawę obliczenia wysokości opłaty emisyjnej podaje się w tysiącach litrów z dokładnością do trzech miejsc po przecinku. </p> <p> <sup>4)</sup>Kwoty opłaty emisyjnej zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2021 r. poz. 1540, z późn. zm.).</p> <p align="center"> <b>Pouczenie:</b> </p> <br/> <p> W przypadku niewpłacenia w obowiązującym terminie opłaty z poz. 20 lub wpłacenia jej w niepełnej wysokości niniejsza informacja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2022 r. poz. 479, z późn. zm.). </p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">OEMIS</span> <sub style="cz9"/> (2) </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>